﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Text;

namespace DataContractJsonSerializerDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            Customer customer = ReadJson();
            WriteJson(customer);
        }

        public static Customer ReadJson()
        {
            string customerJson = "{\"FirstName\":\"Adam\",\"LastName\":\"Calderon\",\"Address\":\"1212 Ocean View Ln.\",\"City\":\"Carlsbad\",\"State\":\"CA\",\"Zip\":\"92008\"}";

            // odczytuje dane z łańcucha w notacji JSON
            byte[] stream = System.Text.Encoding.GetEncoding(
            "iso-8859-1").GetBytes(customerJson);
            MemoryStream memoryStream = new MemoryStream(stream);
            DataContractJsonSerializer jsonSerializer = new DataContractJsonSerializer(typeof(Customer));
            return (Customer)jsonSerializer.ReadObject(memoryStream);

        }

        public static void WriteJson(Customer customer)
        {
            // ponownie zapisuje obiekt w łańcuchu
            MemoryStream memoryStream = new MemoryStream();
            DataContractJsonSerializer jsonSerializer = new DataContractJsonSerializer(typeof(Customer)); 
            jsonSerializer.WriteObject(memoryStream, customer);
            Console.WriteLine(Encoding.GetEncoding("iso-8859-1").GetString(memoryStream.ToArray()));

        }
    }

    [DataContract]
    public class Customer
    {
        [DataMember]
        public string FirstName { get; set; }
        [DataMember]
        public string LastName { get; set; }
        [DataMember]
        public string Address { get; set; }
        [DataMember]
        public string City { get; set; }
        [DataMember]
        public string State { get; set; }
        [DataMember]
        public string Zip { get; set; }

    }

}
